<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RecommendationAttachments extends Eloquent {

	protected $table = 'recommendation_attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('attachment_type_id', 'path', 'recommendation_id');

	public function recommendation()
	{
		return $this->belongsTo('App\Models\Recommendation');
	}

}