<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ResolvedNote extends Eloquent {

	protected $table = 'resolved_notes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('note_id', 'user_id');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function note()
	{
		return $this->belongsTo('App\Models\Notes');
	}

}