<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('phone', 20)->nullable();
			$table->string('mobile', 20)->nullable();
			$table->datetime('dob')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}