<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUserTable extends Migration {

	public function up()
	{
		Schema::create('admin_user', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->string('name', 60);
			$table->string('email', 255)->unique();
			$table->string('password', 120);
			$table->string('phone', 15)->unique();
			$table->enum('status', array('Active', 'Blocked'))->index();
			$table->string('token', 64)->nullable();
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('admin_user');
	}
}