<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletTable extends Migration {

	public function up()
	{
		Schema::create('wallet', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('user_id')->unsigned();
			$table->string('profile_id', 60);
			$table->datetime('created_date');
			$table->string('user_wallet', 20)->nullable();
			$table->string('video_wallet', 20)->nullable();
			$table->enum('type', array('Wallet', 'VideoWallet'));
			$table->timestamp('created_at')->nullable();
			$table->timestamp('updated_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('wallet');
	}
}