<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('approved_by')->references('id')->on('admin_user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_bank', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_basic_info', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('withdrawal_request', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wallet', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('upgrade_plan', function(Blueprint $table) {
			$table->foreign('basic_plan_id')->references('id')->on('basic_plan')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('video_amount', function(Blueprint $table) {
			$table->foreign('video_id')->references('id')->on('video_list')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reject_reason', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reject_reason', function(Blueprint $table) {
			$table->foreign('decline_by')->references('id')->on('admin_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_approved_by_foreign');
		});
		Schema::table('user_bank', function(Blueprint $table) {
			$table->dropForeign('user_bank_user_id_foreign');
		});
		Schema::table('user_basic_info', function(Blueprint $table) {
			$table->dropForeign('user_basic_info_user_id_foreign');
		});
		Schema::table('withdrawal_request', function(Blueprint $table) {
			$table->dropForeign('withdrawal_request_user_id_foreign');
		});
		Schema::table('wallet', function(Blueprint $table) {
			$table->dropForeign('wallet_user_id_foreign');
		});
		Schema::table('upgrade_plan', function(Blueprint $table) {
			$table->dropForeign('upgrade_plan_basic_plan_id_foreign');
		});
		Schema::table('video_amount', function(Blueprint $table) {
			$table->dropForeign('video_amount_video_id_foreign');
		});
		Schema::table('reject_reason', function(Blueprint $table) {
			$table->dropForeign('reject_reason_user_id_foreign');
		});
		Schema::table('reject_reason', function(Blueprint $table) {
			$table->dropForeign('reject_reason_decline_by_foreign');
		});
	}
}