<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMentionTable extends Migration {

	public function up()
	{
		Schema::create('mention', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('sentiment', array('positive', 'negative', 'neutral'));
			$table->text('fulltext');
			$table->string('url', 2048);
			$table->datetimeTz('date');
			$table->string('location', 256);
			$table->string('author', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('mention');
	}
}