<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InnerCategory extends Eloquent {

	protected $table = 'inner_category';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sub_categories()
	{
		return $this->hasOne('SubCategory');
	}

	public function user_tracking()
	{
		return $this->hasMany('UserTracking');
	}

}