<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('engineer_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('request')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->foreign('represents')->references('id')->on('client')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('client')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contracts-service', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contract')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contracts-service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('service')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('request')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('administrator_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->foreign('engineer_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_client_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_service_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_engineer_id_foreign');
		});
		Schema::table('request', function(Blueprint $table) {
			$table->dropForeign('request_request_id_foreign');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->dropForeign('representative_user_id_foreign');
		});
		Schema::table('representative', function(Blueprint $table) {
			$table->dropForeign('representative_represents_foreign');
		});
		Schema::table('contract', function(Blueprint $table) {
			$table->dropForeign('contract_client_id_foreign');
		});
		Schema::table('contracts-service', function(Blueprint $table) {
			$table->dropForeign('contracts-service_contract_id_foreign');
		});
		Schema::table('contracts-service', function(Blueprint $table) {
			$table->dropForeign('contracts-service_service_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_request_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_administrator_id_foreign');
		});
		Schema::table('log', function(Blueprint $table) {
			$table->dropForeign('log_engineer_id_foreign');
		});
	}
}