<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Cars', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('Customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('M_Treasurys', function(Blueprint $table) {
			$table->foreign('Treasury_id')->references('id')->on('Treasurys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('M_Treasurys', function(Blueprint $table) {
			$table->foreign('employer_id')->references('id')->on('employers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('Cars')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('employer_id')->references('id')->on('employers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('Stocks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('Stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->foreign('travel_id')->references('timestamps')->on('Travels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('m_treasury_id')->references('id')->on('M_Treasurys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->foreign('m_treasury_id')->references('id')->on('M_Treasurys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->foreign('driver_id')->references('id')->on('drivers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->foreign('m_treasury_id')->references('id')->on('advances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('travel_id')->references('id')->on('Travels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('employer_id')->references('id')->on('employers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Cars', function(Blueprint $table) {
			$table->dropForeign('Cars_supplier_id_foreign');
		});
		Schema::table('M_Treasurys', function(Blueprint $table) {
			$table->dropForeign('M_Treasurys_Treasury_id_foreign');
		});
		Schema::table('M_Treasurys', function(Blueprint $table) {
			$table->dropForeign('M_Treasurys_employer_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_car_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_driver_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_customer_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_employer_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_stock_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_stock_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_product_id_foreign');
		});
		Schema::table('t_products', function(Blueprint $table) {
			$table->dropForeign('t_products_travel_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_customer_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_m_treasury_id_foreign');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->dropForeign('custodys_driver_id_foreign');
		});
		Schema::table('custodys', function(Blueprint $table) {
			$table->dropForeign('custodys_m_treasury_id_foreign');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->dropForeign('advances_driver_id_foreign');
		});
		Schema::table('advances', function(Blueprint $table) {
			$table->dropForeign('advances_m_treasury_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_travel_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_customer_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_employer_id_foreign');
		});
	}
}