<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title')->nullable();
			$table->text('url');
			$table->enum('type', array('image', 'file', 'voice', 'video'));
			$table->string('ext')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}