<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Conversation extends Model 
{

    protected $table = 'conversations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function bot()
    {
        return $this->belongsTo('Model\Bot');
    }

    public function intent()
    {
        return $this->belongsTo('Model\Intent');
    }

}