<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExternalTrainingsTable extends Migration {

	public function up()
	{
		Schema::create('external_trainings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->bigInteger('department_id')->unsigned()->nullable()->index();
			$table->string('course_name', 255)->nullable()->index();
			$table->string('training_type', 255)->nullable();
			$table->integer('status')->nullable();
			$table->timestamp('date_sent')->nullable();
			$table->timestamp('start_date')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->timestamp('last_training_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('external_trainings');
	}
}