<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrainingPlansTable extends Migration {

	public function up()
	{
		Schema::create('training_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->nullable()->index();
			$table->timestamp('date')->nullable()->index();
			$table->integer('type')->nullable();
			$table->integer('status')->nullable();
			$table->text('location')->nullable();
			$table->integer('required_employees')->nullable();
			$table->timestamp('date_sent')->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('training_plans');
	}
}