<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCertificatesTable extends Migration {

	public function up()
	{
		Schema::create('user_certificates', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->nullable()->index();
			$table->bigInteger('exam_id')->unsigned()->nullable()->index();
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->date('issue_date')->nullable()->index();
			$table->string('instructor_name')->nullable()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_certificates');
	}
}