<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('anuncios', function(Blueprint $table) {
			$table->foreign('id_departamento')->references('id')->on('departamentos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('anuncios', function(Blueprint $table) {
			$table->foreign('id_categoria')->references('id')->on('categorias')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_img', function(Blueprint $table) {
			$table->foreign('id_articulo')->references('id')->on('articulos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_votos', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_votos', function(Blueprint $table) {
			$table->foreign('id_articulo')->references('id')->on('articulos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_comentarios', function(Blueprint $table) {
			$table->foreign('id_articulo')->references('id')->on('articulos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('articulos_comentarios', function(Blueprint $table) {
			$table->foreign('id_usuario')->references('id')->on('usuarios')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('anuncios', function(Blueprint $table) {
			$table->dropForeign('anuncios_id_departamento_foreign');
		});
		Schema::table('anuncios', function(Blueprint $table) {
			$table->dropForeign('anuncios_id_categoria_foreign');
		});
		Schema::table('articulos', function(Blueprint $table) {
			$table->dropForeign('articulos_id_usuario_foreign');
		});
		Schema::table('articulos_img', function(Blueprint $table) {
			$table->dropForeign('articulos_img_id_articulo_foreign');
		});
		Schema::table('articulos_votos', function(Blueprint $table) {
			$table->dropForeign('articulos_votos_id_usuario_foreign');
		});
		Schema::table('articulos_votos', function(Blueprint $table) {
			$table->dropForeign('articulos_votos_id_articulo_foreign');
		});
		Schema::table('articulos_comentarios', function(Blueprint $table) {
			$table->dropForeign('articulos_comentarios_id_articulo_foreign');
		});
		Schema::table('articulos_comentarios', function(Blueprint $table) {
			$table->dropForeign('articulos_comentarios_id_usuario_foreign');
		});
	}
}