<?php

namespace Guides;

use Illuminate\Database\Eloquent\Model;

class Week extends Model 
{

    protected $table = 'guide_weeks';
    public $timestamps = true;

    public function bucket()
    {
        return $this->belongsToMany('Bucket');
    }

    public function guide()
    {
        return $this->belongsTo('Guide', 'guide_id', 'id');
    }

    public function Period()
    {
        return $this->belongsToMany('Period', 'id', 'period_id')->withPivot('periods_weeks');
    }

    public function document()
    {
        return $this->hasMany('GuideDocument')->withPivot('documents_weeks');
    }

    public function localWeek()
    {
        return $this->hasOne('LocalWeek', 'week_id', 'id');
    }

}