<?php

namespace Guides;

class Bucket extends Eloquent {

	protected $table = 'guide_buckets';
	public $timestamps = true;

	public function week()
	{
		return $this->belongsToMany('Week')->withPivot('buckets_weeks');
	}

	public function question()
	{
		return $this->belongsTo('Question', 'question_id', 'id');
	}

	public function guide()
	{
		return $this->belongsTo('Guide', 'guide_id', 'id');
	}

	public function localBucket()
	{
		return $this->hasOne('LocalBucket', 'bucket_id', 'id');
	}

}