<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function GetUpazilaByUser()
	{
		return $this->hasOne('User', 'upazila_id');
	}

	public function GetUnionByUser()
	{
		return $this->hasOne('User', 'union_id');
	}

}