<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Loans extends Model 
{

    protected $table = 'loans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('employee_id', 'amount', 'type', 'monthly_amount', 'months', 'remain');

    public function employee()
    {
        return $this->belongsTo('Employees', 'employee_id');
    }

}