<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('position');
			$table->double('daily_salary');
			$table->string('national_id')->nullable();
			$table->string('mobile')->nullable();
			$table->integer('job_number');
			$table->double('house_allowance')->nullable();
			$table->integer('site_id');
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}