<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomeTable extends Migration {

	public function up()
	{
		Schema::create('income', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('site_id');
			$table->string('name');
			$table->double('amount');
			$table->string('note')->nullable();
			$table->string('check_number');
			$table->date('check_date');
		});
	}

	public function down()
	{
		Schema::drop('income');
	}
}