<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLoansTable extends Migration {

	public function up()
	{
		Schema::create('loans', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id');
			$table->double('amount');
			$table->enum('type', array('Postponed', 'monthly'));
			$table->double('monthly_amount');
			$table->integer('months');
			$table->double('remain');
		});
	}

	public function down()
	{
		Schema::drop('loans');
	}
}