<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnerexpensesTable extends Migration {

	public function up()
	{
		Schema::create('partnerexpenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('site_id');
			$table->double('amount');
			$table->date('date');
			$table->string('note')->nullable();
			$table->string('expense_item');
			$table->enum('type', array('capital', 'consumed'));
			$table->integer('partner_id');
		});
	}

	public function down()
	{
		Schema::drop('partnerexpenses');
	}
}