<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Capitals extends Eloquent {

	protected $table = 'capitals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'site_id', 'employee_id');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employees', 'employee_id');
	}

}