<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Loans extends Eloquent {

	protected $table = 'loans';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('employee_id', 'amount', 'type', 'monthly_amount', 'months', 'remain');

	public function employee()
	{
		return $this->belongsTo('Employees', 'employee_id');
	}

}