<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PartnerExpenses extends Eloquent {

	protected $table = 'partnerexpenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('site_id', 'amount', 'date', 'note', 'expense_item', 'type', 'partner_id');

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

	public function partner()
	{
		return $this->belongsTo('Partners', 'partner_id');
	}

}