<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Salary extends Eloquent {

	protected $table = 'salary';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('month', 'employee_id', 'total_hours', 'deduction', 'loan', 'site_id', 'total', 'salary', 'total_days');

	public function employee()
	{
		return $this->belongsTo('Employees', 'employee_id');
	}

	public function site()
	{
		return $this->belongsTo('Sites', 'site_id');
	}

}