<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesOrdersTable extends Migration {

	public function up()
	{
		Schema::create('courses_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id');
			$table->string('student_name', 255)->nullable();
			$table->string('student_email', 255)->nullable();
			$table->string('student_phone', 20)->nullable();
			$table->integer('country_id');
			$table->integer('ages_group_id');
			$table->bigInteger('city_id');
			$table->bigInteger('school_id')->nullable();
			$table->date('start_date')->nullable();
			$table->date('end_date')->nullable();
			$table->smallInteger('weeks_number')->nullable();
			$table->boolean('accommodation')->default(0);
			$table->bigInteger('course_id');
			$table->boolean('transportation')->default(0);
			$table->bigInteger('accommodation_id');
			$table->double('estimated_total_price')->nullable();
			$table->bigInteger('advisor_id');
			$table->tinyInteger('status')->default('0');
			$table->string('tracking_number', 255);
			$table->bigInteger('technetion_id');
		});
	}

	public function down()
	{
		Schema::drop('courses_orders');
	}
}