<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalesTable extends Migration {

	public function up()
	{
		Schema::create('sales', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->longText('name');
			$table->double('price');
			$table->longText('description')->nullable();
			$table->integer('city_id');
			$table->string('longitude', 255)->nullable();
			$table->string('latitude', 255)->nullable();
			$table->bigInteger('user_id');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('sales');
	}
}