<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalarySheetTable extends Migration {

	public function up()
	{
		Schema::create('salary_sheet', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_id')->nullable();
			$table->integer('monthly_days')->nullable();
			$table->integer('working_days')->nullable();
			$table->double('total_sales')->nullable();
			$table->integer('per_day')->nullable();
			$table->double('basic_salary')->nullable();
			$table->double('commission')->nullable();
			$table->double('previous_due')->nullable();
			$table->double('tips')->nullable();
			$table->double('incentive')->nullable();
			$table->double('housing')->nullable();
			$table->double('transport')->nullable();
			$table->double('medical')->nullable();
			$table->double('bonus')->nullable();
			$table->double('mobile')->nullable();
			$table->double('food')->nullable();
			$table->double('travelling')->nullable();
			$table->double('gross_salary')->nullable();
			$table->double('housing_d')->nullable();
			$table->double('transport_d')->nullable();
			$table->double('mobile_d')->nullable();
			$table->double('loan')->nullable();
			$table->double('absent')->nullable();
			$table->double('advance')->nullable();
			$table->string('sick_leave')->nullable();
			$table->double('penalty')->nullable();
			$table->double('total_deductions')->nullable();
			$table->double('net_salary')->nullable();
			$table->double('paid_salary')->nullable();
			$table->double('relay')->nullable();
			$table->string('paid_way')->nullable();
			$table->datetime('paid_date')->nullable();
			$table->string('branch')->nullable();
			$table->date('month')->nullable();
			$table->date('year')->nullable();
			$table->integer('mall_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('salary_sheet');
	}
}