<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashBacksTable extends Migration {

	public function up()
	{
		Schema::create('cash_backs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->text('description')->nullable();
			$table->integer('order_id')->unsigned()->nullable();
			$table->double('amount')->nullable();
			$table->enum('status', array('pending', 'accepted', 'refused', 'payed'))->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cash_backs');
	}
}