<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOauthAccessTokensTable extends Migration {

	public function up()
	{
		Schema::create('oauth_access_tokens', function(Blueprint $table) {
			$table->string('id', 100)->primary();
			$table->bigInteger('user_id')->nullable();
			$table->integer('client_id')->unsigned();
			$table->string('name', 255)->nullable();
			$table->text('scopes')->nullable();
			$table->tinyInteger('revoked');
			$table->datetime('created_at')->nullable();
			$table->datetime('updated_at');
			$table->datetime('expires_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('oauth_access_tokens');
	}
}