<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletCreditsTable extends Migration {

	public function up()
	{
		Schema::create('wallet_credits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('wallet_id');
			$table->integer('customer_id');
			$table->double('wallet_credit_amount', 20,2);
			$table->string('wallet_credit_type', 100);
			$table->integer('wallet_credit_by_id');
			$table->integer('wallet_credit_status');
			$table->string('wallet_credit_description');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('wallet_credits');
	}
}