<?php

namespace Module/Admin/Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Address extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function order_address_relation()
    {
        return $this->hasOne('Order', 'address_id');
    }

    public function participation_address_relation()
    {
        return $this->hasOne('Participation', 'address_id');
    }

}