<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatesTable extends Migration {

	public function up()
	{
		Schema::create('rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->morphs('userable');
			$table->morphs('reviewable');
			$table->text('comment');
			$table->boolean('show')->default(1);
			$table->double('service_rate', 8,2)->default('0.0');
			$table->double('speed_rate', 8,2)->default('0.0');
			$table->double('communication_rate', 8,2)->default('0.0');
			$table->double('rate', 8,2)->default('0.0');
		});
	}

	public function down()
	{
		Schema::drop('rates');
	}
}