<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\Model;

class Prescription extends Model 
{

    protected $table = 'prescriptions';
    public $timestamps = true;
    protected $fillable = array('type', 'medicine_name', 'note', 'dosage_id', 'prescription_validation_id', 'booking_id');

    public function prescriptionValidation()
    {
        return $this->belongsTo('PrescriptionValidation');
    }

    public function dosage()
    {
        return $this->belongsTo('Dosage');
    }

    public function booking()
    {
        return $this->belongsTo('Booking');
    }

}