<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingImagesTable extends Migration {

	public function up()
	{
		Schema::create('booking_images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->bigInteger('booking_id')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
			$table->enum('type', array('x_ray', 'medical_analysis', 'prescription'));
		});
	}

	public function down()
	{
		Schema::drop('booking_images');
	}
}