<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('prescriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('tablets', 'syrup', 'injection', 'other'));
			$table->string('medicine_name', 255);
			$table->text('note');
			$table->bigInteger('dosage_id')->unsigned()->nullable();
			$table->bigInteger('prescription_validation_id')->unsigned()->nullable();
			$table->bigInteger('booking_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('prescriptions');
	}
}