<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShiftsTable extends Migration {

	public function up()
	{
		Schema::create('shifts', function(Blueprint $table) {
			$table->increments('id');
			$table->time('start');
			$table->time('end');
			$table->bigInteger('setting_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
			$table->integer('days_of_week_id')->unsigned();
			$table->bigInteger('place_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('shifts');
	}
}