<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('post_id')->unsigned();
			$table->json('hashtags');
			$table->string('title');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}