<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdvertisementsTable extends Migration {

	public function up()
	{
		Schema::create('advertisements', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('category_id');
			$table->integer('brand_id');
			$table->integer('currency_id');
			$table->text('year')->nullable();
			$table->text('mileage')->nullable();
			$table->longText('location')->nullable();
			$table->string('weight')->nullable();
			$table->text('model')->nullable();
			$table->text('stelnr')->nullable();
			$table->text('refnr')->nullable();
			$table->text('aksel')->nullable();
			$table->text('price')->nullable();
			$table->datetime('date_registered')->nullable();
			$table->text('description')->nullable();
			$table->boolean('status')->default(true);
			$table->integer('views');
			$table->text('video_url')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('advertisements');
	}
}