<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;
    protected $fillable = array('email');

    public function entity()
    {
        return $this->belongsTo('Entity');
    }

    public function customerType()
    {
        return $this->belongsTo('CustomerType');
    }

    public function customerClass()
    {
        return $this->belongsTo('CustomerClass');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription');
    }

}