<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubscriptionPeriod extends Model 
{

    protected $table = 'subscription_periods';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function share()
    {
        return $this->belongsTo('Share');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription');
    }

}