<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->foreign('fund_type_id')->references('id')->on('fund_type')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('funds', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shares', function(Blueprint $table) {
			$table->foreign('fund_id')->references('id')->on('funds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscription_periods', function(Blueprint $table) {
			$table->foreign('share_id')->references('id')->on('shares')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('entity_id')->references('id')->on('entities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('customer_type_id')->references('id')->on('entities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('customer_class_id')->references('id')->on('customer_class')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('subscription_period_id')->references('id')->on('subscription_periods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('questionnaire')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('subscriptions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_share', function(Blueprint $table) {
			$table->foreign('counrty_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country_share', function(Blueprint $table) {
			$table->foreign('share_id')->references('id')->on('shares')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('funds', function(Blueprint $table) {
			$table->dropForeign('funds_fund_type_id_foreign');
		});
		Schema::table('funds', function(Blueprint $table) {
			$table->dropForeign('funds_country_id_foreign');
		});
		Schema::table('shares', function(Blueprint $table) {
			$table->dropForeign('shares_fund_id_foreign');
		});
		Schema::table('subscription_periods', function(Blueprint $table) {
			$table->dropForeign('subscription_periods_share_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_entity_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_customer_type_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_customer_class_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_customer_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_subscription_period_id_foreign');
		});
		Schema::table('subscriptions', function(Blueprint $table) {
			$table->dropForeign('subscriptions_questionnaire_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_subscription_id_foreign');
		});
		Schema::table('country_share', function(Blueprint $table) {
			$table->dropForeign('country_share_counrty_id_foreign');
		});
		Schema::table('country_share', function(Blueprint $table) {
			$table->dropForeign('country_share_share_id_foreign');
		});
	}
}