<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSharesTable extends Migration {

	public function up()
	{
		Schema::create('shares', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('fund_id')->unsigned();
			$table->string('isin');
			$table->float('price');
			$table->float('percentage', 3,2);
			$table->string('currency_name');
			$table->integer('nominal');
			$table->integer('mqnp');
			$table->integer('mqfp');
			$table->string('mime_type_logo');
			$table->binary('data_logo');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('shares');
	}
}