<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('course_name');
			$table->integer('no_modules');
			$table->string('image_icon');
			$table->tinyInteger('active');
			$table->text('addressed')->nullable();
			$table->text('description')->nullable();
			$table->string('meta_keywords');
			$table->text('meta_description')->nullable();
			$table->string('plan')->nullable();
			$table->integer('no_lessons')->nullable();
			$table->smallInteger('priority')->default('0');
			$table->float('default_price')->nullable();
			$table->integer('no_tests')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}