<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('project_name');
			$table->string('project_image');
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->integer('company_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}