<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionRequestsTable extends Migration {

	public function up()
	{
		Schema::create('subscription_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('fullname', 255);
			$table->bigInteger('nationality_id')->unsigned();
			$table->enum('gender', array('male', 'female'));
			$table->string('national_address', 100);
			$table->string('region', 50);
			$table->string('identity_number', 50);
			$table->string('work_address', 100);
			$table->string('job_title', 100);
			$table->bigInteger('degree_id')->unsigned();
			$table->string('home_address', 100);
			$table->string('status');
		});
	}

	public function down()
	{
		Schema::drop('subscription_requests');
	}
}