<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tower extends Model 
{

    protected $table = 'tower';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'city_id');

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function subscriptions()
    {
        return $this->hasMany('Subscription', 'tower_id');
    }

}